#Compare hash of downloaded files
#Author: Xpert for PCtipp 02/2020
#Version 1.1 05.03.2020

function Restart(){
$restart = Read-Host -Prompt "Neuer Vergleich (1), Exit (0)? "

if($restart -match 0){
exit
}
HashCompare
}

function HashCompare(){
	
Add-Type -AssemblyName System.Windows.Forms
$choosePathOption = ""

cls
#Algorithms to choose from
$const_sha1 = "sha1"
$const_sha256 = "sha256"
$const_sha384 = "sha384"
$const_sha512 = "sha512"
$const_MACTripleDES = "MACTripleDES"
$const_md5 = "md5"
$const_RIPEMD160 = "RIPEMD160"

$FileBrowser = New-Object System.Windows.Forms.OpenFileDialog -Property @{ InitialDirectory = [Environment]::GetFolderPath('Desktop') }

$choosePathOption = Read-Host -Prompt "Pfad einfgen oder '1' fr Datei-Explorer"

if($choosePathOption -match '1'){
$null = $FileBrowser.ShowDialog()
$pathToFile = $FileBrowser.FileName 
}
else{
$pathToFile = $choosePathOption
}



$ChooseAlgorithmToUse = Read-Host -Prompt "Welchen Algorithmus (0-6)? $const_sha1 (0), $const_sha256 (1), $const_sha384 (2), $const_sha512 (3), $const_MACTripleDES (4), $const_md5 (5),  $const_RIPEMD160 (6)" 

    

    switch ( $ChooseAlgorithmToUse )
    {
        0 { $AlgorithmToUse = "sha1"    }
        1 { $AlgorithmToUse = "sha256"    }
        2 { $AlgorithmToUse = "sha384"   }
        3 { $AlgorithmToUse = "sha512" }
        4 { $AlgorithmToUse = "MACTripleDES"  }
        5 { $AlgorithmToUse = "md5"    }
        6 { $AlgorithmToUse = "RIPEMD160"  }
    }

$pathToFile = $pathToFile -replace ('"', '')

$hashExpected = Read-host -Prompt "Erwarteter Hash (z.B. auf Webseite angegeben) zur Kontrolle"
    
Write-Host "Berechne Hash und vergleiche... bitte warten"
$hashFromFile = get-filehash -path $pathToFile -Algorithm $AlgorithmToUse | Select -ExpandProperty "Hash"



if($hashExpected -match $hashFromFile){
Write-Host "Vergleich positiv" -ForegroundColor Green
Write-host $hashExpected.ToLower() 
Write-Host $hashFromFile.ToLower()
Restart
}
Write-Host "Vergleich negativ" -ForegroundColor Red
Write-host $hashExpected.ToLower()
Write-Host $hashFromFile.ToLower()
Restart

}

HashCompare